
;Include Modern UI

  !include "MUI.nsh"



;--------------------------------
;Please edit the line below.

Name "My Sample DDNS Client"
  
;Do not edit below this line! 
;--------------------------------


  BrandingText "DDNS Enterprise Installer v2.0.0.0"
  OutFile "ClientSetup.exe"
  ;Default installation folder
  InstallDir "$PROGRAMFILES\Enterprise DDNS Client"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\Enterprise DDNS Client" ""

  ;RequestExecutionLevel admin
;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages
   !define MULTIUSER_EXECUTIONLEVEL Admin
   ;!define MULTIUSER_MUI

   ;!define MULTIUSER_NOUNINSTALL ;Uncomment if no uninstaller is created
   !include MultiUser.nsh

  !define MUI_ICON "DDNS Enterprise Client\orange-install.ico" 
  !define MUI_UNICON "DDNS Enterprise Client\orange-uninstall.ico"
  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP "DDNS Enterprise Client\black.bmp"
  !insertmacro MUI_PAGE_LICENSE "DDNS Enterprise Client\License.txt"
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !define MUI_FINISHPAGE
  !define MUI_FINISHPAGE_RUN "$INSTDIR\DDNS.exe"
  !insertmacro MUI_PAGE_FINISH

  ;!insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  ;!insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;.net download text

LangString DESC_REMAINING ${LANG_ENGLISH} " (%d %s%s remaining)"
LangString DESC_PROGRESS ${LANG_ENGLISH} "%d.%01dkB/s" ;"%dkB (%d%%) of %dkB @ %d.%01dkB/s"
LangString DESC_PLURAL ${LANG_ENGLISH} "s"
LangString DESC_HOUR ${LANG_ENGLISH} "hour"
LangString DESC_MINUTE ${LANG_ENGLISH} "minute"
LangString DESC_SECOND ${LANG_ENGLISH} "second"
LangString DESC_CONNECTING ${LANG_ENGLISH} "Connecting..."
LangString DESC_DOWNLOADING ${LANG_ENGLISH} "Downloading .Net Framework v2.0 %s"
LangString DESC_DOWNLOADINGM ${LANG_ENGLISH} "Downloading MDAC v2.7 %s"
LangString DESC_INSTALLING ${LANG_ENGLISH} "Installing .Net Framework v2.0"
LangString DESC_INSTALLINGM ${LANG_ENGLISH} "Installing MDAC v2.7"
LangString DESC_DOWNLOADING1 ${LANG_ENGLISH} "Downloading"
LangString DESC_DOWNLOADFAILED ${LANG_ENGLISH} "Download Failed:"



;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------



;--------------------------------
;Version Information

  VIProductVersion "1.2.3.4"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "ProductName" "MintDNS v2.0 Enterprise Client"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "Comments" "MintDNS Client System."
  VIAddVersionKey /LANG=${LANG_ENGLISH} "CompanyName" "Adams-Land micro systems."
  VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalTrademarks" "MintDNS is a trademark of Adams-Land micro systems"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalCopyright" " Adams-Land micro systems."
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileDescription" "MintDNS 2008 Enterprise. 10/03/2008 5:22AM"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileVersion" "2.0.0.0"

;--------------------------------


Function .onInit
!insertmacro MULTIUSER_INIT
Call GetWindowsVersion
;Call GetDotNet
 FunctionEnd

Function un.onInit
  !insertmacro MULTIUSER_UNINIT
FunctionEnd

Function GetWindowsVersion
   Push $R0
   ClearErrors
    ReadRegStr $R0 HKLM \
   "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
  IfErrors 0 lbl_winnt
    ReadRegStr $R0 HKLM \
   "SOFTWARE\Microsoft\Windows\CurrentVersion" VersionNumber
   Goto Dbl_error
   lbl_winnt:
   Goto lbl_done
   Dbl_error:
   MessageBox MB_OK 'This software will not work with your operating system. Setup will not continue. '
   Abort
  lbl_done:
FunctionEnd



Section GetDotNet SECDOTNET 
  IfFileExists "$WINDIR\Microsoft.NET\Framework\v2.0.50727\installUtil.exe" NextStep
 MessageBox MB_YESNO|MB_ICONQUESTION "You must have the Microsoft .NET Framework 2.0 Installed to use this application.$\nWould you like to download and install the .NET Framework 2.0?" IDYES YesInstall IDNO NoAbort
NoAbort:
Abort
YesInstall:
;NSISdl::download /TIMEOUT=30000 /TRANSLATE http://www.microsoft.com/downloads/info.aspx?na=90&p=&SrcDisplayLang=en&SrcCategoryId=&SrcFamilyId=0856eacb-4362-4b0d-8edd-aab15c5e04f5&u=http%3a%2f%2fdownload.microsoft.com%2fdownload%2f5%2f6%2f7%2f567758a3-759e-473e-bf8f-52154438565a%2fdotnetfx.exe "$TEMP\dotnetfx.exe" 
;NSISdl::download /TIMEOUT=30000 /TRANSLATE http://www.ddns.com/ddns.exe "$TEMP\ddns.exe" 
DetailPrint "$(DESC_DOWNLOADING)..."
AddSize 286720
 nsisdl::download /TRANSLATE "$(DESC_DOWNLOADING)" "$(DESC_CONNECTING)" \
       "$(DESC_SECOND)" "$(DESC_MINUTE)" "$(DESC_HOUR)" "$(DESC_PLURAL)" \
       "$(DESC_PROGRESS)" "$(DESC_REMAINING)" \
       /TIMEOUT=30000 "http://download.microsoft.com/download/5/6/7/567758a3-759e-473e-bf8f-52154438565a/dotnetfx.exe" "$TEMP\dotnetfx.exe"
    Pop $0
    StrCmp "$0" "success" lbl_continue
    DetailPrint "$(DESC_DOWNLOADFAILED) $0"
    Abort
     lbl_continue:
      DetailPrint "$(DESC_INSTALLING) ..."
      Banner::show /NOUNLOAD "$(DESC_INSTALLING)..."
      nsExec::ExecToStack '"$TEMP\dotnetfx.exe" /q /c:"install.exe /noaspupgrade /q"'
      SetRebootFlag false
      Banner::destroy
Goto NextStep
NextStep:
 SectionEnd






Section "Install and register dll's" instA
SetOutPath "$INSTDIR"
SetOverwrite try
      File "DDNS Enterprise Client\DDNS.exe"
      File "DDNS Enterprise Client\Mints.exe"
      File "DDNS Enterprise Client\InstallUtil.exe"
      File "DDNS Enterprise Client\progdb.mdb"
      File "DDNS Enterprise Client\help.chm"
      File "DDNS Enterprise Client\ServiceStart.exe"
      File "DDNS Enterprise Client\ServiceStop.exe"
ExecWait "$INSTDIR\InstallUtil.exe Mints.exe /i /LogToConsole=False"
ExecWait "$INSTDIR\ServiceStart.exe"
SectionEnd


Section "CreateShOrt" Dingle

    CreateDirectory "$SMPROGRAMS\DDNS Enterprise Client"
    CreateShortCut "$SMPROGRAMS\DDNS Enterprise Client\DDNS Enterprise Client.lnk" "$INSTDIR\DDNS.exe"
    CreateShortCut "$SMPROGRAMS\DDNS Enterprise Client\Help.lnk" "$INSTDIR\help.chm"
    CreateShortCut "$SMPROGRAMS\DDNS Enterprise Client\Uninstall.lnk" "$INSTDIR\Uninstall.exe"


SectionEnd  
Section "Dummy Section" SecDummy

  SetOutPath "$INSTDIR"
;Store installation folder
  WriteRegStr HKCU "Software\Modern UI Test" "" $INSTDIR
  
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd
;--------------------------------
;Uninstaller Section
;Uninstaller Section

Section "Uninstall"
SetOutPath "$INSTDIR"
  ;ADD YOUR OWN FILES HERE...

ExecWait "$INSTDIR\ServiceStop.exe"
Delete "$SMPROGRAMS\DDNS Enterprise Client\DDNS Enterprise Client.lnk"
Delete "$SMPROGRAMS\DDNS Enterprise Client\Help.lnk"
Delete "$SMPROGRAMS\DDNS Enterprise Client\Uninstall.lnk"
Delete "$INSTDIR\DDNS.exe"
Delete "$INSTDIR\help.chm"
Delete "$INSTDIR\ServiceStart.exe"
ExecWait "$INSTDIR\InstallUtil.exe Mints.exe /u /LogToConsole=False" 
Delete "$INSTDIR\ServiceStop.exe"
Delete "$INSTDIR\InstallUtil.InstallLog"
Delete "$INSTDIR\Mints.InstallLog"
Delete "$INSTDIR\progdb.ldb"
Delete "$INSTDIR\Uninstall.exe"
Delete "$INSTDIR\progdb.mdb"
Delete "$INSTDIR\InstallUtil.exe"
Delete "$INSTDIR\Mints.exe"

  RMDir "$INSTDIR"
  RMDir "$SMPROGRAMS\DDNS Enterprise Client"
  DeleteRegKey /ifempty HKCU "Software\DDNS Enterprise Client"

SectionEnd